﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Microsoft.Phone.Controls;
using System.Diagnostics;
using Microsoft.Phone.Notification;

namespace ReceiveTile
{
    public partial class MainPage : PhoneApplicationPage
    {
        string channelName = "TileNotification";
        HttpNotificationChannel channel;

        // Constructor
        public MainPage()
        {
            InitializeComponent();

            channel = HttpNotificationChannel.Find(channelName);

            if (channel == null)
            {
                channel = new HttpNotificationChannel(channelName);
                channel.ChannelUriUpdated += channel_ChannelUriUpdated;
                channel.ErrorOccurred += channel_ErrorOccured;
                channel.Open();

                channel.BindToShellTile();
            }
            else
            {
                channel.ChannelUriUpdated += channel_ChannelUriUpdated;
                channel.ErrorOccurred += channel_ErrorOccured;
            }
        }

        void channel_ErrorOccured(object sender,
                NotificationChannelErrorEventArgs e)
        {
            switch (e.ErrorType)
            {
                case ChannelErrorType.ChannelOpenFailed:
                    break;
            }
        }

        void channel_ChannelUriUpdated(object sender,
            NotificationChannelUriEventArgs e)
        {
            Debug.WriteLine(e.ChannelUri.ToString());
        }
    }
}